package tests;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;

import javax.swing.JFrame;
import javax.swing.JPanel;

import model.Execution;
import model.IExecution;
import model.ProxyExecution;
import view.ComparisonsPanel;
import view.NPanel;
import view.TimesPanel;
/**
 * Test vista
 * @author koelio
 *
 */
public class Test1 {

	static JFrame frame;

	public static Frame getFrame() {
		// TODO Auto-generated method stub
		return frame;
	}

	public static void main(String[] args) {

		Test1.frame = new JFrame();
		frame.setTitle("Test1");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(300, 600);

		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
		frame.setLocation((int) (dim.getWidth() - frame.getWidth()) / 2,
				(int) (dim.getHeight() - frame.getHeight()) / 2);
		
		JPanel panel = new JPanel();
		frame.getContentPane().add(panel);
		panel.setLayout(new BorderLayout());
		
		IExecution execution = new Execution();
		ProxyExecution realexeExecution = new ProxyExecution(execution);
		
		NPanel nPanel = new NPanel(realexeExecution);
		ComparisonsPanel compPanel = new ComparisonsPanel(realexeExecution);
		TimesPanel timePane = new TimesPanel(realexeExecution);
		
		frame.setVisible(true);
		panel.add(nPanel, BorderLayout.NORTH);
		panel.add(compPanel,BorderLayout.CENTER);
		panel.add(timePane,BorderLayout.EAST);
		
	}
}
